log using "C:\Users\Dan WALDO\Documents\DOL\Mar2013\Stata\Mar2013 creation.log" , replace
* ============================================ 
*
*  read in.do
*
*  This code creates an analytic file from the
*  March 2013 supplement to the CPS.
*
*  The user should change the path and folder
*  for the input flat dataset and the output
*  Stata file. These are found about a third
*  of the way into this file and nearly at the
*  end of this file, respectively.
*
*  The user should also change the path and
*  folder for the log file, located on the
*  first line of this file.
*
*  Source: Cathi Callahan
*  Actuarial Research Corporation

clear
set mem 500m
set more on

#delimit ;
  infile
  phseq
  hnumper
  alineno
  esiph
  esidep
  ophiph
  ophidep
  nmcaid
  nmcare
  champ
  other
  chipp
  marsupwt
  offer
  prior
  newsector
  newsize
  eeprior
  phline
  siflag
  hmoflag
  retflag
  ph2line
  newsector2
  newsize2
  union
  eeunion
  unionwork
  av
  avcellavg
  av_exper
  mspflag
  oopexp
  using "C:\Users\Dan WALDO\Documents\DOL\Mar2013\newout6pff.13";
#delimit cr
  replace marsupwt=marsupwt/100
  format marsupwt %9.2f
  compress

  label var phseq  "Household Sequence Number"
  label var hnumper  "Number of Persons in Household"
  label var alineno  "Person Line Number"
  label var esiph  "ESI policy holder?"
  label var esidep  "ESI dependent?"
  label var ophiph  "Other private health insurance policy holder?"
  label var ophidep  "Other private health insurance dependent?"
  label var nmcaid  "Covered by Medicaid?"
  label var nmcare  "Covered by Medicare?"
  label var champ  "Covered by Military?"
  label var other  "Covered by Other?"
  label var chipp  "Covered by Childrens Health Insurance?"
  label var marsupwt  "March Supplement Weight"
  label var offer  "Does your employer offer Health Insurance?"
  label var prior  "Do you have ESI through a Prior Employer?"
  label var newsector  "What sector is providing coverage?"
  label var newsize  "What size employer provided the coverage?"
  label var eeprior  "Coverage through a prior employer (dependents only, attribute of policyholder)"
  label var phline  "Line number (ALINENO) of First Policy holder (deps. who are not ESI policy holders only)"
  label var siflag  "Was coverage fully-insured or self-insured?"
  label var hmoflag  "What type of plan are you covered by?"
  label var retflag  "Is prior coverage retiree or COBRA? (universe is PRIOR1 or EEPRIOR1)"
  label var ph2line  "Line number (ALINENO) of second policy holder"
  label var newsector2  "Sector of coverage through second policy holder (if PH2LINE > 0). "
  label var newsize2  "Size of employer covering through second policy holder (if PH2LINE>0)"
  label var union  "Coverage through union? (for ESI Policy holders only, non-self-employed)"
  label var eeunion  "Coverage through a union? (for ESI deps only, based on PH attribute)"
  label var unionwork  "Union? (for non-self-employed workers only, current employment status)"
  label var av  "Actuarial Value (active ESI policy holder records only)"
  label var avcellavg  "Cell based average actuarial value (active ESI policy holder records only)"
  label var av_exper  "Experimental Actuarial Value (active ESI policy holder records only)"
  label var mspflag  "Medicare Secondary Payer variable (all Medicare)"
  label var oopexp  "Out of Pocket Expenditures on Over the Counter Purchases and Medical Equipment (sum of POTC-VAL and PMED-VAL)"

#delimit ;
  label define yesnof
    0 "0 no"
    1 "1 yes";
  label define offerf
    0 "0 n/a"
    1 "1 coverage through current employer"
    2 "2 offered, eligible, not enrolled"
    3 "3 offered, not enrolled, not eligible"
    4 "4 not offered";
  label define priorf
    0 "0 n/a"
    1 "1 yes"
    2 "2 no, current employer";
  label define newsectorf
    0 "0 n/a"
    1 "1 Private"
    2 "2 Public, Federal"
    3 "3 Public, State"
    4 "4 Public, Local"
    5 "5 Self-Employed, inc"
    6 "6 Self-Employed, uninc";
  label define newsizef
    0 "0 n/a"
    1 "1 less than 10"
    2 "2 10 - 49"
    3 "3 50 - 99"
    4 "4 100 - 499"
    5 "5 500 - 999"
    6 "6 1000 or more";
  label define eepriorf
    0 "0 n/a"
    1 "1 yes, prior"
    2 "2 no, current employer";
  label define siflagf
    0 "0 n/a"
    1 "1 self-insured"
    2 "2 fully-insured";
  label define hmoflagf
    0 "0 n/a"
    1 "1 HMO"
    2 "2 PPO"
    3 "3 POS"
    4 "4 HDED";
  label define retflagf
    0 "0 n/a"
    1 "1 retiree" 
    2 "2 COBRA";
  label define unionf
    0 "0 n/a"
    1 "1 yes, union"
    2 "2 no, not union";
  label define mspflagf
    0 "0 Person does not have Medicare"
    1 "1 Medicare is secondary (ESI Primary)"
    2 "2 Medicare is primary (may or may not have ESI)";
#delimit cr
  label values esiph  yesnof
  label values esidep  yesnof
  label values ophiph  yesnof
  label values ophidep  yesnof
  label values nmcaid  yesnof
  label values nmcare   yesnof
  label values champ  yesnof
  label values other  yesnof
  label values chipp  yesnof
  label values offer  offerf
  label values prior  priorf
  label values newsector  newsectorf
  label values newsize  newsizef
  label values eeprior  eepriorf
  label values siflag  siflagf
  label values hmoflag  hmoflagf
  label values retflag  retflagf
  label values newsector2  newsectorf
  label values newsize2  newsizef
  label values union  unionf
  label values eeunion  unionf
  label values unionwork  unionf
  label values mspflag  mspflagf

  save "C:\Users\Dan WALDO\Documents\DOL\Mar2013\Stata\Mar13" , replace
  describe
  codebook , tabulate(20)

log close
